CREATE OR REPLACE FUNCTION tlog.Auditlog_add_record__create() RETURNS void
  AS $f$
  BEGIN

  EXECUTE $func$

  -- eigentliche Trigger-Funktion zur Verwendung an beliebiger Tabelle
     CREATE OR REPLACE FUNCTION tlog.Auditlog_add_record() RETURNS TRIGGER AS $$
    DECLARE
      txid                  bigint := txid_current();
      key                   varchar;
      json_oldData          json;
      json_newData          json;
      parent_fname          varchar;
      references_tablename  varchar;
      references_FName      varchar;
      references_id         varchar;
      _old                  varchar := '';
      _ident                varchar := null;
    _ident_json           json;

    BEGIN

      -- kein Log f?r Tabelle Settings oder angg. Nutzer, #8395.
      IF      tg_relname = 'settings'
          OR  (
                  current_user IN ( 'syncro', 'postgres', 'root' )
              OR  ( SELECT current_setting( 'server_version_num' )::integer < 90600 )
          )
      THEN
          IF tg_op = 'DELETE' THEN
              RETURN old;
          ELSE -- INSERT, UPDATE
              RETURN new;
          END IF;
      END IF;

      IF tlog.log_audit_active() THEN
          parent_fname := tlog.Auditlog_parent_fname(TG_TABLE_NAME::varchar);

          IF parent_fname IS NOT NULL THEN
              IF tg_op = 'DELETE' THEN
                  EXECUTE format('SELECT $1.%I ', parent_fname) INTO key USING old; -- $1 per USING
              ELSE -- INSERT, UPDATE
                  EXECUTE format('SELECT $1.%I ', parent_fname) INTO key USING new;
              END IF;
          ELSE
              key := 'missing parent field definition for table ' || TG_TABLE_NAME; -- Definition in FUNCTION tlog.Auditlog_parent_fname
          END IF;

          SELECT
            refs.references_tablename,
            refs.references_FName,
            refs.references_id
          INTO
            references_tablename,
            references_FName,
            references_id
          FROM tlog.Auditlog__references__get( TG_TABLE_NAME::VARCHAR, key, _old ) AS refs;

          IF tg_op = 'UPDATE' THEN

              BEGIN
                  _ident := TLog.Auditlog__table__ident(new);
                  _ident := replace( _ident, '    =    ', ' = ');
                  _ident := replace( _ident, ',    ', ', ');
              EXCEPTION WHEN others THEN
                  RAISE WARNING 'Fehlende Funktion TLog.Auditlog__table__ident(%)', TG_TABLE_NAME::VARCHAR;
              END;
        BEGIN
                  _ident_json := TLog.Auditlog__table__ident_json(new);
              EXCEPTION WHEN others THEN
                  RAISE WARNING 'Fehlende Funktion TLog.Auditlog__table__ident_json(%)', TG_TABLE_NAME::VARCHAR;
              END;

              IF old.* IS DISTINCT FROM new.* THEN
                  SELECT row_to_json( old ) INTO json_oldData; -- old-Stand in JSON umwandeln
                  SELECT row_to_json( new ) INTO json_newData; -- new-Stand in JSON umwandeln
                  SELECT json_old, json_new INTO json_oldData, json_newData FROM tlog.log__json__old_new__compare(json_oldData, json_newData);

                  IF length( trim( json_newData::text ) ) > 2 THEN
                      IF NOT EXISTS(SELECT true FROM tlog.Auditlog WHERE l_json_new::text = json_newData::text AND l_txid = txid AND l_ident = _ident) THEN  -- Absprache DG-OG #9442
                          -- (DG) Bedingung entfernt: Identische ?nderung am selben Tag vom selben Benutzer nicht loggen.
                          -- Ziel war: Abfangen ?berfl?ssiger Eintr?ge interner Updates durch Trigger.
                          -- Problem: relevante Nutzereingabe werden nicht geloggt und Performance.
                          INSERT INTO tlog.Auditlog(
                            l_id,                                 l_tablename,                              l_time,         l_txid, l_operation,
                            l_json_old,   l_json_new,   l_dbrid,  l_parent_ID,  l_parent_FName,
                            l_references_tablename, l_references_FName, l_references_id,
                            l_ident, l_ident_json
                            )
                          SELECT
                            nextval( 'tlog.auditlog_l_id_seq' ),  TG_TABLE_SCHEMA || '.' || TG_TABLE_NAME,  currenttime(),  txid,   substr( tg_op, 1, 1 ),
                            json_oldData, json_newData, new.dbrid, key,         parent_fname,
                            references_tablename,   references_FName,   references_id,
                            _ident, _ident_json
                          ;

                       END IF;
                  END IF;
              END IF;

          ELSIF tg_op = 'INSERT' THEN
              SELECT row_to_json( new ) INTO json_newData;

              BEGIN
                  _ident := TLog.Auditlog__table__ident(new);
                  _ident := replace( _ident, '    =    ', ' = ');
                  _ident := replace( _ident, ',    ', ', ');
              EXCEPTION WHEN others THEN
                  RAISE WARNING 'Fehlende Funktion TLog.Auditlog__table__ident(%)', TG_TABLE_NAME::VARCHAR;
              END;
        BEGIN
                  _ident_json := TLog.Auditlog__table__ident_json(new);
              EXCEPTION WHEN others THEN
                  RAISE WARNING 'Fehlende Funktion TLog.Auditlog__table__ident_json(%)', TG_TABLE_NAME::VARCHAR;
              END;

              INSERT INTO tlog.Auditlog(
                l_id,                                 l_tablename,                              l_time,         l_txid, l_operation,
                l_dbrid,    l_json_new,   l_parent_ID,  l_parent_FName, l_references_tablename, l_references_FName, l_references_id,
                l_ident, l_ident_json
                )
              SELECT
                nextval( 'tlog.auditlog_l_id_seq' ),  TG_TABLE_SCHEMA || '.' || TG_TABLE_NAME,  currenttime(),  txid,   substr( tg_op, 1, 1 ),
                new.dbrid,  json_newData, key,          parent_fname,   references_tablename,   references_FName,   references_id,
                _ident, _ident_json
              ;

          ELSIF tg_op = 'DELETE' THEN
              SELECT row_to_json( old ) INTO json_oldData;

              BEGIN
                  _ident := TLog.Auditlog__table__ident(old);
                  _ident := replace( _ident, '    =    ', ' = ');
                  _ident := replace( _ident, ',    ', ', ');
              EXCEPTION WHEN others THEN
                  RAISE WARNING 'Fehlende Funktion TLog.Auditlog__table__ident(%)', TG_TABLE_NAME::VARCHAR;
              END;
        BEGIN
                  _ident_json := TLog.Auditlog__table__ident_json(old);
              EXCEPTION WHEN others THEN
                  RAISE WARNING 'Fehlende Funktion TLog.Auditlog__table__ident_json(%)', TG_TABLE_NAME::VARCHAR;
              END;

              INSERT INTO tlog.Auditlog(
                l_id,                                 l_tablename,                              l_time,         l_txid, l_operation,
                l_dbrid,    l_json_old,   l_parent_ID,  l_parent_FName, l_references_tablename, l_references_FName, l_references_id,
                l_ident, l_ident_json
                )
              SELECT
                nextval( 'tlog.auditlog_l_id_seq' ),  TG_TABLE_SCHEMA || '.' || TG_TABLE_NAME,  currenttime(),  txid,   substr( tg_op, 1, 1 ),
                old.dbrid,  json_oldData, key,          parent_fname,   references_tablename,   references_FName,   references_id,
                _ident, _ident_json
              ;

          END IF;
      END IF;

      RETURN new;
    END $$ LANGUAGE plpgsql;
    --
  $func$ --  EXECUTE end
  RETURN;
END $f$ LANGUAGE plpgsql;


--DROP TABLE IF EXISTS tlog.bdep__terminal_datafox__errorlog;
--Für loggen der kollidierten Stempelndaten
CREATE TABLE tlog.bdep__terminal_datafox__errorlog
 (tde_id                serial PRIMARY KEY,
  tde_rfid              text,
  tde_device_type       varchar,
  tde_software_version  varchar,
  tde_net_ip            varchar,
  tde_terminal_info     varchar,
  tde_abw_id            integer,
  tde_stempel_zeitpunkt timestamp,
  tde_status_only       boolean NOT NULL DEFAULT FALSE,
  tde_msg_error         text,
  tde_done              boolean NOT NULL DEFAULT FALSE
 );

--DROP FUNCTION bdep__terminal_datafox__errorlog__b_iu__stempelzeit()
CREATE OR REPLACE FUNCTION bdep__terminal_datafox__errorlog__b_iu__stempelzeit() RETURNS TRIGGER AS $$
  BEGIN
    IF new.tde_stempel_zeitpunkt IS NULL THEN
    new.tde_stempel_zeitpunkt := currenttime(); --Zeit vom Server für online-Datensätze
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

--DROP TRIGGER IF EXISTS bdep__terminal_datafox__errorlog__b_iu__stempelzeit ON tlog.bdep__terminal_datafox__errorlog;
CREATE TRIGGER bdep__terminal_datafox__errorlog__b_iu__stempelzeit
    BEFORE INSERT OR UPDATE OF tde_stempel_zeitpunkt
    ON tlog.bdep__terminal_datafox__errorlog
    FOR EACH ROW
    EXECUTE FUNCTION bdep__terminal_datafox__errorlog__b_iu__stempelzeit();
--

SELECT tlog.Auditlog_add_record__create();
